import {Component} from 'components/Component';

export class AviaFlightTimings extends Component {
    readonly departure: Component;
    readonly arrival: Component;
    readonly duration: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-flight-timings') {
        super(browser, qa);

        this.departure = new Component(browser, {
            parent: this.qa,
            current: 'departure',
        });
        this.arrival = new Component(browser, {
            parent: this.qa,
            current: 'arrival',
        });
        this.duration = new Component(browser, {
            parent: this.qa,
            current: 'duration',
        });
    }
}
