import {Component} from 'components/Component';

export class AviaBookingTraveller extends Component {
    readonly fullName: Component;
    readonly fullDocument: Component;
    readonly birthDate: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.fullName = new Component(browser, {
            parent: this.qa,
            current: 'fullName',
        });

        this.fullDocument = new Component(browser, {
            parent: this.qa,
            current: 'fullDocument',
        });

        this.birthDate = new Component(browser, {
            parent: this.qa,
            current: 'birthDate',
        });
    }
}
