import {AviaSearchForm} from 'helpers/project/avia/components/AviaSearchForm';

import {Component} from 'components/Component';
import {Page} from 'components/Page';

const AVIA_QA_PREFIX = 'avia';
const DIRECTION_PAGE_QA_PREFIX = `${AVIA_QA_PREFIX}-directionPage`;

export class AviaDirectionPage extends Page {
    searchForm: AviaSearchForm;
    directionPageBreadcrumps: Component;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.directionPageBreadcrumps = new Component(this.browser, {
            parent: DIRECTION_PAGE_QA_PREFIX,
            current: 'breadcrumps',
        });

        this.searchForm = new AviaSearchForm(this.browser);
    }
}
