import {Component} from 'components/Component';

export class AviaBookingBreadcrumbs extends Component {
    readonly search: Component;
    readonly order: Component;
    readonly form: Component;
    readonly payment: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-booking-banner') {
        super(browser, qa);

        this.search = new Component(browser, {
            parent: this.qa,
            current: 'item-search',
        });
        this.order = new Component(browser, {
            parent: this.qa,
            current: 'item-order',
        });
        this.form = new Component(browser, {
            parent: this.qa,
            current: 'item-form',
        });
        this.payment = new Component(browser, {
            parent: this.qa,
            current: 'item-payment',
        });
    }
}
