import {Component} from 'components/Component';
import {Button} from 'components/Button';
import {TestErrorModal} from 'components/TestErrorModal';

export class AviaBookingErrorModal extends TestErrorModal {}

export class AviaBookingPriceChangedErrorModal extends TestErrorModal {
    private readonly newPrice: Component;
    private readonly closeModal: Button;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, {
            parent: 'aviaBookingModalError',
            current: 'PriceChanged',
        });

        this.newPrice = new Component(browser, {
            path: [this.qa],
            current: 'price',
        });

        this.closeModal = new Button(browser, {
            parent: this.qa,
            current: 'primaryAction',
        });
    }

    getNewPrice(): Promise<string> {
        return this.newPrice.getText();
    }

    async close(): Promise<void> {
        await this.closeModal.click();
    }
}
