import {ETestDocumentType} from 'components/TestBookingPassengerForm/types';

const DOCUMENTS_MAP: Partial<Record<ETestDocumentType, string>> = {
    [ETestDocumentType.RU_NATIONAL_PASSPORT]: 'Паспорт РФ',
    [ETestDocumentType.RU_FOREIGN_PASSPORT]: 'Заграничный паспорт',
};

export const getDocumentName = (type?: ETestDocumentType) =>
    type ? DOCUMENTS_MAP[type] : undefined;
