import {AviaOrderOffers} from './components/Offers';
import {AviaOrderRoute} from './components/Route';
import {AviaOrderHeader} from './components/Header';
import {AviaOrderOffer} from './components/Offer';
import {AviaOrderDisclaimers} from './components/Disclaimers';
import {Component} from 'components/Component';
import {TestCheckButton} from 'components/TestCheckButton';
import TestLayoutDefault from 'components/TestLayoutDefault/TestLayoutDefault';

export class AviaOrderPage extends TestLayoutDefault {
    readonly outdateError: Component;
    readonly offers: AviaOrderOffers;
    readonly forward: AviaOrderRoute;
    readonly backward: AviaOrderRoute;
    readonly orderHeader: AviaOrderHeader;
    readonly disclaimers: AviaOrderDisclaimers;
    readonly baggageFilter: TestCheckButton;
    readonly bestOffer: AviaOrderOffer;
    readonly aviaOrderComplete: Component;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, 'aviaOrder');

        this.orderHeader = new AviaOrderHeader(browser, {
            parent: this.qa,
            current: 'header',
        });

        this.baggageFilter = new TestCheckButton(browser, {
            parent: this.qa,
            current: 'baggage-filter',
        });

        this.outdateError = new Component(browser, 'aviaOrderOutdateError');

        this.offers = new AviaOrderOffers(browser, {
            parent: this.qa,
            current: 'offers',
        });

        this.forward = new AviaOrderRoute(browser, {
            parent: this.qa,
            current: 'forward-route',
        });

        this.backward = new AviaOrderRoute(browser, {
            parent: this.qa,
            current: 'backward-route',
        });

        this.disclaimers = new AviaOrderDisclaimers(browser, {
            parent: this.qa,
            current: 'disclaimers',
        });

        this.bestOffer = new AviaOrderOffer(browser, {
            path: [this.qa, 'bestOffer'],
            current: 'offer',
        });

        this.aviaOrderComplete = new Component(browser, {
            parent: this.qa,
            current: 'complete',
        });
    }

    async waitForLoading(timeout = 30000): Promise<void> {
        await this.aviaOrderComplete.waitForVisible(timeout);
    }
}
