import TestAviaPartnerLogo from 'helpers/project/avia/pages/OrderPage/components/TestAviaPartnerLogo';

import {Component} from 'components/Component';

export class AviaOrderOffer extends Component {
    readonly logo: TestAviaPartnerLogo;
    readonly price: Component;
    readonly button: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-order-offer') {
        super(browser, qa);

        this.logo = new TestAviaPartnerLogo(browser, {
            parent: this.qa,
            current: 'logo',
        });

        this.price = new Component(browser, {
            parent: this.qa,
            current: 'price',
        });

        this.button = new Component(browser, {
            parent: this.qa,
            current: 'button',
        });
    }
}
