import {Component} from 'components/Component';
import {ComponentArray} from 'components/ComponentArray';

import {AviaOrderFlight} from './Flight';
import {AviaOrderRouteTitle} from './RouteTitle';

export class AviaOrderRoute extends Component {
    readonly title: AviaOrderRouteTitle;
    readonly flights: ComponentArray<AviaOrderFlight>;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-order-route') {
        super(browser, qa);

        this.title = new AviaOrderRouteTitle(browser, {
            parent: this.qa,
            current: 'title',
        });
        this.flights = new ComponentArray(
            browser,
            {parent: this.qa, current: 'flight'},
            AviaOrderFlight,
        );
    }
}
