import {Component} from 'components/Component';
import {TestSelect} from 'components/TestSelect';

export enum ESortingType {
    INTEREST = 'avia/sort-by/INTEREST',
    PRICE = 'avia/sort-by/PRICE',
    DEPARTURE = 'avia/sort-by/DEPARTURE',
    ARRIVAL = 'avia/sort-by/ARRIVAL',
    DURATION = 'avia/sort-by/DURATION',
}

export class AviaSorting extends Component {
    readonly order: Component;
    readonly typeSelect: TestSelect;
    readonly ascIcon: Component;
    readonly descIcon: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.order = new Component(browser, {
            parent: this.qa,
            current: 'order',
        });
        this.typeSelect = new TestSelect(browser, {
            parent: this.qa,
            current: 'type',
        });
        this.ascIcon = new Component(browser, {
            parent: this.qa,
            current: 'ascIcon',
        });
        this.descIcon = new Component(browser, {
            parent: this.qa,
            current: 'descIcon',
        });
    }

    async selectSortOption(value: ESortingType): Promise<void> {
        await this.typeSelect.selectByValue(value, 4000);
    }

    async isAscOrder(): Promise<boolean> {
        return this.ascIcon.isVisible();
    }

    async isDescOrder(): Promise<boolean> {
        return this.descIcon.isVisible();
    }
}
