import {Component} from 'components/Component';

export class AviaTransferData extends Component {
    readonly departure: Component;
    readonly arrival: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA = 'avia-transfer-data') {
        super(browser, qa);

        this.departure = new Component(browser, {
            parent: this.qa,
            current: 'departure',
        });
        this.arrival = new Component(browser, {
            parent: this.qa,
            current: 'arrival',
        });
    }
}
