import {EPaymentFailureResponseCode} from 'helpers/project/common/api/types/EPaymentFailureResponseCode';

export interface IGetPaymentTestContextTokenParams {
    paymentOutcome: 'PO_SUCCESS' | 'PO_FAILURE';
    /**
     * Таблица с причинами
     * https://wiki.yandex-team.ru/trust/payments/rc/
     */
    paymentFailureResponseCode?: EPaymentFailureResponseCode;
    /**
     * Описание может быть условно любым
     */
    paymentFailureResponseDescription?: string;
    /**
     * Формат: https://en.wikipedia.org/wiki/ISO_8601#Durations
     * Пример: PT10S
     */
    minUserActionDelay?: string;
    maxUserActionDelay?: string;
    /** Ссылка на тестовую форму оплаты */
    paymentUrl?: string;
}

export interface IGetPaymentTestContextTokenResponse {
    token: string;
}
