import {Component} from './Component';

export class AdFoxBanner extends Component {
    constructor(browser: WebdriverIO.Browser, qa = 'ad-fox-banner') {
        super(browser, qa);
    }

    /**
     * Отключаем события мыши на баннере AdFox,
     * потому что иногда баннер перехватывает события попапов которые находятся над ним
     */
    async disableEvents(): Promise<void> {
        await this.browser.execute(selector => {
            const element = document.querySelector(selector);

            if (element instanceof HTMLElement) {
                element.style.pointerEvents = 'none';
            }
        }, this.selector);
    }

    async enableEvents(): Promise<void> {
        await this.browser.execute(selector => {
            const element = document.querySelector(selector);

            if (element instanceof HTMLElement) {
                element.style.pointerEvents = 'auto';
            }
        }, this.selector);
    }
}
