import {SECOND} from 'helpers/constants/dates';

import {Component} from 'components/Component';

export class Calendar extends Component {
    constructor(browser: WebdriverIO.Browser, qa: QA = 'calendar') {
        super(browser, qa);
    }

    async clickCalendarDate(date: string): Promise<void> {
        const day = new Component(this.browser, {
            parent: this.qa,
            current: `day-${date}`,
        });

        await day.scrollIntoView();
        await day.click();
    }

    /**
     * Календарь открывается с анимацией прокручивания к текущему дню, поэтому если не подождать можно сделать miss click
     */
    async waitScrollAnimation(): Promise<void> {
        await this.browser.pause(SECOND);
    }
}
