import * as formFields from '../form/formFields';
import {Component} from './Component';
import {Button} from './Button';

export class Form extends Component {
    submitButton: Button;
    cancelButton: Button | undefined;

    constructor(
        browser: WebdriverIO.Browser,
        formSelector: QA,
        submitSelector: QA = '',
        cancelSelector: string = '',
    ) {
        super(browser, formSelector);

        this.submitButton = new Button(browser, submitSelector);

        if (cancelSelector) {
            this.cancelButton = new Button(browser, cancelSelector);
        }
    }

    /** @depricated - используйте компонентный подход */
    async fill(fields: formFields.TFieldParams[]): Promise<void> {
        await this.waitForVisible();

        await formFields.fillInConstructor()(this.browser, fields);
    }

    async submit(): Promise<void> {
        await this.submitButton.click();
    }

    async cancel(): Promise<void> {
        if (this.cancelButton) {
            await this.cancelButton.click();
        }
    }
}
