import {Component} from './Component';

interface IHeaderSearchInformationParams {
    date: string;
    direction: string;
}

export class HeaderSearchInformation extends Component {
    direction: Component;
    date: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.direction = new Component(browser, {
            parent: this.qa,
            current: 'direction',
        });
        this.date = new Component(browser, {parent: this.qa, current: 'date'});
    }

    async getSearchParams(): Promise<IHeaderSearchInformationParams> {
        const direction = await this.direction.getText();
        const date = await this.date.getText();

        return {
            date,
            direction,
        };
    }
}
