import {ComponentArray} from 'components/ComponentArray';
import {TestLink} from 'components/TestLink';

import {Component} from './Component';

export class IndexTabs extends Component {
    readonly aviaTab: TestLink;
    readonly trainsTab: TestLink;
    readonly hotelsTab: TestLink;
    readonly busesTab: TestLink;
    private readonly tabs: ComponentArray<TestLink>;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, 'indexTabs');

        this.tabs = new ComponentArray(
            browser,
            {
                parent: this.qa,
                current: 'indexTab',
            },
            TestLink,
        );
        this.aviaTab = this.getProjectTab('avia');
        this.trainsTab = this.getProjectTab('trains');
        this.hotelsTab = this.getProjectTab('hotels');
        this.busesTab = this.getProjectTab('buses');
    }

    async getActiveTab(): Promise<TestLink | undefined> {
        return this.tabs.find(async tab => {
            return (await tab.getAttribute('data-active')) === 'true';
        });
    }

    async getActiveTabInfo(): Promise<{text: string; pathname: string | null}> {
        const activeTab = await this.getActiveTab();

        if (!activeTab) {
            throw new Error('Активная вкладка не найдена');
        }

        const [pathname, text] = await Promise.all([
            activeTab.getRelativePathName(),
            activeTab.getText(),
        ]);

        return {
            text,
            pathname,
        };
    }

    private getProjectTab(project: string): TestLink {
        return new TestLink(this.browser, {
            parent: this.qa,
            current: 'indexTab',
            key: project,
        });
    }
}
