import {
    CommandOptions,
    Value,
} from 'webdriverio/build/commands/element/addValue';

import {Component} from './Component';

export class Input extends Component {
    /**
     * @param value - значение для инпута
     * @param isMasked - есть ли маска у инпута. Если есть, то нужно вводить символы по одному иначе в некоторых браузерах могут ввестись не все символы.
     */
    async type(value: string, isMasked: boolean = false): Promise<void> {
        if (isMasked) {
            const dividedValue = value.split('');

            for (const char of dividedValue) {
                await this.addValue(char);
            }
        } else {
            await this.setValue(value);
        }
    }

    async setValue(
        value: Value | Value[],
        options?: CommandOptions,
    ): Promise<void> {
        await this.clearValue();

        await super.addValue(value, options);
    }

    /**
     *  Очищаем через Backspace
     */
    async clearValue(): Promise<void> {
        const currentValue = await super.getValue();

        const backSpaces = new Array(currentValue.length).fill('Backspace');

        await super.setValue(backSpaces);
    }
}
