import {Component} from 'components/Component';
import {TestHeader} from 'components/TestHeader';
import {TestFooter} from 'components/TestFooter';

export class Page extends Component {
    readonly header: TestHeader;
    readonly footer: TestFooter;

    constructor(browser: WebdriverIO.Browser, qa?: QA) {
        super(browser, qa);

        this.header = new TestHeader(browser);
        this.footer = new TestFooter(browser, 'portalFooter');
    }
}
