import {Component} from './Component';

export class Radio extends Component {
    text: Component;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.text = new Component(browser, {
            parent: this.qa,
            current: 'text',
        });
    }

    /**
     * На сам input isVisible возвращает false
     */
    async isVisible(timeout: number = 3000): Promise<boolean> {
        return this.text.isVisible(timeout);
    }

    async isChecked(): Promise<boolean> {
        const checked = await this.getAttribute('checked');

        return checked === 'true';
    }
}
