import {prepareLabelSelector, prepareSafeSelector} from './utils';

/**
 * 1) Find field label by id and click,
 * 2) check that control is focused,
 * 3) add value to control
 */
export async function fillIn(
    browser: WebdriverIO.Browser,
    id: string,
    value: string,
): Promise<void> {
    const labelSelector = prepareLabelSelector(id);
    const controlSelector = prepareSafeSelector(`#${id}`);

    const labelElement = await browser.$(labelSelector);

    await labelElement.click();

    const controlElement = await browser.$(controlSelector);

    await browser.waitUntil(() => {
        return controlElement.isFocused();
    });

    let val = await controlElement.getValue();

    while (val !== '') {
        await controlElement.addValue('\uE003');

        val = await browser.$(controlSelector).getValue();
    }

    for (let i = 0; i < value.length; i++) {
        if (value[i] !== '.') {
            await controlElement.addValue(value[i]);
        }
    }
}
