import {prepareLabelSelector} from './utils';

/**
 * 1) Find field label by id and then find adjacant radio labels,
 * 2) Find radio label by text and then click
 */
export async function fillIn(
    browser: WebdriverIO.Browser,
    id: string,
    value: string,
): Promise<void> {
    const labelSelector = prepareLabelSelector(id);
    const controlSelector = (index: number): string =>
        `${labelSelector} + div span label:nth-child(${index})`;

    let i = 2;

    // eslint-disable-next-line no-constant-condition
    while (true) {
        const element = await browser.$(controlSelector(i));
        const text = await element.getText();

        if (text === value) {
            const controlElement = await browser.$(controlSelector(i));

            await controlElement.click();

            return;
        }

        i += 1;
    }
}
