import {prepareLabelSelector, prepareSafeSelector} from './utils';

/**
 * 1) Find field label by id and click,
 * 2) check that control is focused,
 * 3) add value to control
 */
export async function fillIn(
    browser: WebdriverIO.Browser,
    id: string,
    value: string,
): Promise<void> {
    const labelSelector = prepareLabelSelector(id);
    const controlSelector = prepareSafeSelector(`[id='${id}']`);

    const controlElement = browser.$(controlSelector);

    /**
     * Для тачей нужно проскроллить во вьюпорт, иначе клик не попадет в нужный элемент
     */
    await controlElement.scrollIntoView({block: 'center'});

    const labelElement = browser.$(labelSelector);

    await labelElement.click();

    try {
        await browser.waitUntil(() => controlElement.isFocused(), {
            timeoutMsg: `Поле ${controlSelector} не стало в фокусе после клика по лейблу ${labelSelector}`,
        });
    } catch (e) {
        console.error(e);

        await controlElement.click();

        await browser.waitUntil(() => controlElement.isFocused(), {
            timeoutMsg: `Поле ${controlSelector} не стало в фокусе после клика по нему`,
        });
    }

    let val = await controlElement.getValue();

    while (val !== '') {
        await controlElement.addValue('\uE003');

        val = await browser.$(controlSelector).getValue();
    }

    await controlElement.addValue(value);
}
