import {delay as delayFunc} from './delay';

export function retry(
    func: (...args: any[]) => void,
    options?: {attempts: number; delay: number},
) {
    const {attempts = 3, delay = 0} = options || {};

    return async function (...args: any[]) {
        let count = 0;
        let error;

        while (count < attempts) {
            try {
                return await func(...args);
            } catch (e) {
                error = e;
            }

            await delayFunc(delay);

            count++;
        }

        throw error;
    };
}
