import {Component} from 'components/Component';
import {SearchFormFieldModal} from 'components/SearchFormFieldModal';
import {TravellersCount} from 'components/TravellersCount';
import {TestNativeSelect} from 'components/TestNativeSelect';

export class HotelsTravellers extends Component {
    adultsCount: TravellersCount;
    modal: SearchFormFieldModal;
    trigger: Component;
    childSelect: TestNativeSelect;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.trigger = new Component(browser, {
            parent: this.qa,
            current: 'trigger',
        });

        this.adultsCount = new TravellersCount(browser, {
            parent: 'travellersCount',
            key: 'adults',
        });

        this.modal = new SearchFormFieldModal(this.browser);

        this.childSelect = new TestNativeSelect(browser, 'native-select');
    }

    async click(): Promise<void> {
        await this.trigger.click();
    }

    async addChildren(age: number): Promise<void> {
        await this.childSelect.selectByValue(age);
    }
}
