/* eslint-disable camelcase */

// Полное описание интерфейса в одноимённом файле в server
export interface ITrainsTestContextTokenParams {
    // Результат получения цены страховки
    insurancePricingOutcome: 'IPO_UNKNOWN' | 'IPO_SUCCESS' | 'IPO_FAILURE';
    // Результат выписывания страховки
    insuranceCheckoutOutcome: 'ICO_UNKNOWN' | 'ICO_SUCCESS' | 'ICO_FAILURE';
    // Результат подтверждения выписанной страховки (после оплаты)
    insuranceCheckoutConfirmOutcome:
        | 'ICCO_UNKNOWN'
        | 'ICCO_SUCCESS'
        | 'ICCO_FAILURE';
    // Результат получения стоимости к возврату
    refundPricingOutcome: 'RPO_UNKNOWN' | 'RPO_SUCCESS' | 'RPO_FAILURE';
    // Результат проведения авто-возврата
    refundCheckoutOutcome: 'RCO_UNKNOWN' | 'RCO_SUCCESS' | 'RCO_FAILURE';
    // Результат создания бронирования
    createReservationOutcome: 'RCRO_UNKNOWN' | 'RCRO_SUCCESS' | 'RCRO_FAILURE';
    // Результат подтверждения бронирования
    confirmReservationOutcome: 'RCOO_UNKNOWN' | 'RCOO_SUCCESS' | 'RCOO_FAILURE';
    // Ограничения для таймаутов - стоит ставить не меньше 10 секунд, чтобы не флапало (бывают лаги на беке до 6 с)
    // Период возврата билета через кассу (в секундах). Если не задано или 0 - возврата не будет
    officeReturnDelayInSeconds?: number;
    // Период получения билета в кассе (в секундах). Если не задано или 0 - билет не должен быть получен в кассе
    officeAcquireDelayInSeconds?: number;
    // Период времени в секундах, после которого запрос на обновление данных в ИМ будет завершаться таймаутом. Если не задано или 0 - таймаута не будет
    alwaysTimeoutAfterConfirmingInSeconds?: number;
}

export interface ITrainsTestContextTokenAnswer {
    test_context_token: string;
}
