import {TestOrderSummary} from 'helpers/project/trains/components/TestOrderSummary/TestOrderSummary';
import {TestTrainsOrderSteps} from 'helpers/project/trains/components/TestTrainsOrderSteps';

import TestLayoutDefault from 'components/TestLayoutDefault/TestLayoutDefault';

/**
 * Общие элементы на страницах заказа в ЖД
 */
export default class TrainsOrderPageLayout extends TestLayoutDefault {
    orderSummary: TestOrderSummary;
    orderSteps: TestTrainsOrderSteps;

    constructor(browser: WebdriverIO.Browser) {
        super(browser, 'trainsOrderPage');

        this.orderSummary = new TestOrderSummary(browser, 'pageOrderSummary');

        this.orderSteps = new TestTrainsOrderSteps(browser);
    }

    async goNextStep(): Promise<void> {
        await this.orderSummary.orderButton.click();
    }
}
