import moment, {Moment} from 'moment';
import _random from 'lodash/random';

import dateFormats from 'helpers/utilities/date/formats';

const getNextWeekRandomDay = (): {
    date: Moment;
    dateString: string;
} => {
    const date = moment()
        .set('day', 1)
        .add(1, 'week')
        .add(_random(3, 7), 'day');
    const dateString = date.format(dateFormats.ROBOT);

    return {date, dateString};
};

export default getNextWeekRandomDay;
