import {
    AEROFLOT_QUERY_FILTER,
    S7_QUERY_FILTER,
} from 'helpers/constants/avia/filters';

const DEFAULT_FILTERS = [S7_QUERY_FILTER, AEROFLOT_QUERY_FILTER];

/**
 * Функция перебора фильтров авиакомпании для повышения стабильности автотестов
 * (если пропадают предложения одной компании, то автотесты прогоняются для другой)
 */
export function buildNextQueryFilter(
    filters: string[] = DEFAULT_FILTERS,
): () => string {
    let currentFilterIndex = 0;

    return (): string => {
        const filter = filters[currentFilterIndex];

        currentFilterIndex =
            currentFilterIndex + 1 >= filters.length
                ? currentFilterIndex + 1
                : 0;

        return filter;
    };
}
