import {CHAR_SIX_PER_EM_SPACE} from 'helpers/utilities/strings/charCodes';

/**
 * Форатирует целое число.
 *
 * @param {number|string} number - Целое число.
 * @param {string='&thinsp;'} thousandsDelimiter - Разделитель тысяч.
 *
 * @return {string}
 */
export default function formatInteger(
    number: number | string,
    thousandsDelimiter: string = CHAR_SIX_PER_EM_SPACE,
): string {
    const str: string = String(number);
    const len = str.length;

    let i = len % 3 || 3;
    let result = str.substr(0, i);

    for (; i < len; i += 3) {
        result = `${result}${thousandsDelimiter}${str.substr(i, 3)}`;
    }

    return result;
}
