import {prepareName} from 'suites/lib/core';

const SUITE_NAME_PREFIX = 'Автобусы';

export const BASE_URL = '/buses/';

export interface IBusesSuitSearchPoint {
    id?: number;
    slug: string;
    name: {
        base: string;
        from: string;
        to: string;
    };
}

const msk: IBusesSuitSearchPoint = {
    id: 213,
    slug: 'moscow',
    name: {
        base: 'Москва',
        from: 'Москвы',
        to: 'Москву',
    },
};
const ekb: IBusesSuitSearchPoint = {
    id: 54,
    slug: 'yekaterinburg',
    name: {
        base: 'Екатеринбург',
        from: 'Екатеринбурга',
        to: 'Екатеринбург',
    },
};
const voronezh: IBusesSuitSearchPoint = {
    slug: 'voronezh',
    name: {
        base: 'Воронеж',
        from: 'Воронежа',
        to: 'Воронеж',
    },
};
const spb: IBusesSuitSearchPoint = {
    slug: 'saint-petersburg',
    name: {
        base: 'Санкт-Петербург',
        from: 'Санкт-Петербурга',
        to: 'Санкт-Петербург',
    },
};
const vng: IBusesSuitSearchPoint = {
    slug: 'veliky-novgorod',
    name: {
        base: 'Великий Новгород',
        from: 'Великого Новгорода',
        to: 'Великий Новгород',
    },
};
const yaroslavl: IBusesSuitSearchPoint = {
    slug: 'yaroslavl',
    name: {
        base: 'Ярославль',
        from: 'Ярославля',
        to: 'Ярославль',
    },
};
const tver: IBusesSuitSearchPoint = {
    slug: 'tver',
    name: {
        base: 'Тверь',
        from: 'Твери',
        to: 'Тверь',
    },
};
const kaliningrad: IBusesSuitSearchPoint = {
    slug: 'kaliningrad',
    name: {
        base: 'Калининград',
        from: 'Калининграда',
        to: 'Калининград',
    },
};
const kazan: IBusesSuitSearchPoint = {
    slug: 'kazan',
    name: {
        base: 'Казань',
        from: 'Казани',
        to: 'Казань',
    },
};

const newport: IBusesSuitSearchPoint = {
    slug: 'newport-gb',
    name: {
        base: 'Ньюпорт',
        from: 'Ньюпорта',
        to: 'Ньюпорт',
    },
};

export const SUITES = {
    regions: {
        msk,
        ekb,
        voronezh,
        spb,
        vng,
        kazan,
        newport,
    },
    routes: [
        [msk, kazan],
        [kaliningrad, msk],
        [msk, voronezh],
        [msk, spb],
        [yaroslavl, msk],
        [msk, tver],
        [msk, kaliningrad],
    ],
    pages: {
        index: {
            name: prepareName(SUITE_NAME_PREFIX, 'Главная'),
            url: BASE_URL,
        },
        search: {
            date: {
                name: prepareName(SUITE_NAME_PREFIX, 'Поиск'),
                getUrl: ({
                    fromSlug,
                    toSlug,
                    when,
                }: {
                    fromSlug: string;
                    toSlug: string;
                    when: string;
                }): string => `${BASE_URL}${fromSlug}--${toSlug}/?date=${when}`,
            },
        },
    },
};
