const {prepareName} = require('./lib/core');

const SUITE_NAME_PREFIX = 'Отели';
const BASE_URL = '/hotels/';
const SEARCH_PAGE_URL = 'search';
const HOTEL_PAGE_URL = 'hotel';
const BOOK_PAGE_URL = 'book';
const HAPPY_PAGE_URL = 'success';
const TRAVELLINE_OFFER_PAGE_URL = 'offer/travelline';

export const index = {
    url: BASE_URL,
    name: prepareName(SUITE_NAME_PREFIX, 'Главная'),
};

export const serp = {
    url: `${BASE_URL}${SEARCH_PAGE_URL}/`,
    name: prepareName(SUITE_NAME_PREFIX, 'Поиск отелей'),
};

export const hotel = {
    url: `${BASE_URL}${HOTEL_PAGE_URL}/`,
    name: prepareName(SUITE_NAME_PREFIX, 'Страница отеля'),
};

export const book = {
    url: `${BASE_URL}${BOOK_PAGE_URL}/`,
    name: prepareName(SUITE_NAME_PREFIX, 'Бронирование отелей'),
};

export const happyPage = {
    url: `${BASE_URL}${HAPPY_PAGE_URL}/`,
    name: prepareName(SUITE_NAME_PREFIX, 'Happy page'),
};

export const cityPage = {
    name: prepareName(SUITE_NAME_PREFIX, 'Страница города'),
};

export const travellineOfferPage = {
    url: `${BASE_URL}${TRAVELLINE_OFFER_PAGE_URL}`,
    name: prepareName(SUITE_NAME_PREFIX, 'Принятие оферты для Travelline'),
};
