import {prepareName} from './lib/core';

const SUITE_NAME_PREFIX = 'Поезда';
const BASE_URL = '/trains/';

export interface ITrainsSuitSearchPoint {
    id?: number;
    slug: string;
    name: {
        base: string;
        from: string;
        to: string;
    };
}

const msk: ITrainsSuitSearchPoint = {
    id: 213,
    slug: 'moscow',
    name: {
        base: 'Москва',
        from: 'Москвы',
        to: 'Москву',
    },
};
const ekb: ITrainsSuitSearchPoint = {
    id: 54,
    slug: 'yekaterinburg',
    name: {
        base: 'Екатеринбург',
        from: 'Екатеринбурга',
        to: 'Екатеринбург',
    },
};
const voronezh: ITrainsSuitSearchPoint = {
    slug: 'voronezh',
    name: {
        base: 'Воронеж',
        from: 'Воронежа',
        to: 'Воронеж',
    },
};
const spb: ITrainsSuitSearchPoint = {
    id: 2,
    slug: 'saint-petersburg',
    name: {
        base: 'Санкт-Петербург',
        from: 'Санкт-Петербурга',
        to: 'Санкт-Петербург',
    },
};
const vng: ITrainsSuitSearchPoint = {
    slug: 'veliky-novgorod',
    name: {
        base: 'Великий Новгород',
        from: 'Великого Новгорода',
        to: 'Великий Новгород',
    },
};
const yaroslavl: ITrainsSuitSearchPoint = {
    slug: 'yaroslavl',
    name: {
        base: 'Ярославль',
        from: 'Ярославля',
        to: 'Ярославль',
    },
};
const tver: ITrainsSuitSearchPoint = {
    slug: 'tver',
    name: {
        base: 'Тверь',
        from: 'Твери',
        to: 'Тверь',
    },
};
const krasnodar: ITrainsSuitSearchPoint = {
    slug: 'krasnodar',
    name: {
        base: 'Краснодар',
        from: 'Краснодара',
        to: 'Краснодар',
    },
};
const sochi: ITrainsSuitSearchPoint = {
    slug: 'sochi',
    name: {
        base: 'Сочи',
        from: 'Сочи',
        to: 'Сочи',
    },
};
const nizhnyNovgorod: ITrainsSuitSearchPoint = {
    slug: 'nizhny-novgorod',
    name: {
        base: 'Нижний Новгород',
        from: 'Нижнего Новгорода',
        to: 'Нижний Новгород',
    },
};
const vladimir: ITrainsSuitSearchPoint = {
    slug: 'vladimir',
    name: {
        base: 'Владимир',
        from: 'Владимира',
        to: 'Владимир',
    },
};

export const regions = {
    msk,
    ekb,
    voronezh,
    spb,
    vng,
    yaroslavl,
    tver,
    krasnodar,
    sochi,
    nizhnyNovgorod,
    vladimir,
};

export const index = {
    url: BASE_URL,
    name: prepareName(SUITE_NAME_PREFIX, 'Главная'),
    regions: {
        moscow: 213,
    },
};

export const serp = {
    url: (fromCity: string, toCity: string, fromDate?: string): string => {
        let pathToDirection = `${BASE_URL}${fromCity}--${toCity}/`;

        if (fromDate) {
            pathToDirection = `${pathToDirection}${fromDate}`;
        }

        return pathToDirection;
    },
    name: prepareName(SUITE_NAME_PREFIX, 'Выдача'),
    qa: {
        searchToolbar: 'search-toolbar',
        sortingDirectionButton: 'sorting-direction-button',
        selectSortTypeTrigger: 'select-sort-type-trigger',
        trainSegment: 'train-segment',
        emptySearch: 'no-trains',
        trainsSegments: 'trains-segments',
        price: 'price',
        allDaysLink: 'all-days-link',
        spinner: 'spinner',
    },
};

export const order = {
    name: prepareName(SUITE_NAME_PREFIX, 'Заказ'),
    steps: {
        places: prepareName(SUITE_NAME_PREFIX, 'Выбор мест'),
        confirmation: prepareName(SUITE_NAME_PREFIX, 'Подтверждение'),
        pay: prepareName(SUITE_NAME_PREFIX, 'Оплата'),
        order: prepareName(SUITE_NAME_PREFIX, 'Страница заказа'),
        happyPage: prepareName(SUITE_NAME_PREFIX, 'Happy page'),
    },
};
