import {prepareName} from 'suites/lib/core';

import {SUITE_NAME_PREFIX} from './komod';

export const activeTripsMocks = [
    {
        title: 'Санкт–Петербург',
        displayDate: 'Послезавтра',
        link: '/my/trips/1',
        imageHref:
            'https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop',
    },
    {
        title: 'Франция',
        displayDate: '24 — 25 мар, 2021',
        link: '/my/trips/2',
        imageHref: null,
    },
    {
        title: 'Лондон',
        displayDate: '5 мая, 2021',
        link: '/my/order/5',
        imageHref: null,
    },
];

export const pastTripsMocks = [
    {
        title: 'Сочи',
        displayDate: '20 дек, 2021 - 11 янв, 2022',
        link: '/my/trips/3',
        imageHref:
            'https://avatars.mds.yandex.net/get-travel-hotels/2409838/region_image_239_1/region-desktop',
    },
    {
        title: 'Санкт-Петербург — Александровск-Сахалинский',
        displayDate: '24 — 25 мар, 2021',
        link: '/my/trips/4',
        imageHref: null,
    },
];

export const burgerMenuActiveTrips = [
    {
        title: 'Санкт–Петербург',
        imageHref:
            'https://avatars.mds.yandex.net/get-travel-hotels/2456341/region_image_213_0/region-desktop',
        link: '/my/trips/1',
    },
    {
        title: 'Франция',
        imageHref: null,
        link: '/my/order/2',
    },
];

export const morePastTrips = [
    {
        title: 'Казань',
    },
    {
        title: 'Ростов-на-Дону',
    },
];

/**
 * Заказ отельный с тестинга
 * для тестирования поиска заказов
 */
export const exampleTestingHotelOrder = {
    prettyOrderId: 'YA-8130-7673-8010',
    orderId: '20edf375-3aef-4bc2-a265-015bb84caeb0',
    email: 'vladlen@yandex.ru',
};

/**
 * Заказ поездов с тестинга
 * для тестирования печати жд заказа из моей поездки
 */
export const exampleTestingTrainOrder = {
    prettyOrderId: 'YA-8886-9809-2943',
    orderId: '616d98aa-c89c-4151-91f9-ac349de68447',
    email: 'autotest@autotest.ru',
};

/**
 * Заказ авиа с тестинга
 * для тестирования перехода на страницу заказа
 */
export const exampleTestingAviaOrder = {
    prettyOrderId: 'YA-5926-3179-5902',
    orderId: '45686023-678f-455c-9b8c-8faafadc9992',
    email: 'vladlen@yandex.ru',
};

export const tripMocks = {
    aviaOrders: [
        {
            title: 'Санкт–Петербург — Александровск–Сахалинск',
            dateForward: '24 ноя, 17:14',
            dateBackward: '24 дек, 22:00',
            directionsShown: true,
            pnr: 'JHG78',
            logosCount: 2,
            link: `/my/order/${exampleTestingAviaOrder.orderId}`,
        },
        undefined,
        {
            title: 'Сочи — Екатеринбург',
            dateForward: '24 ноя, 17:14',
            dateBackward: null,
            directionsShown: false,
            pnr: 'OHF88',
            logosCount: 1,
            link: '/my/order/3',
        },
        undefined,
        undefined,
        undefined,
    ],
    trainOrders: [
        {
            title: 'Санкт–Петербург — Александровск–Сахалинск',
            dateForward: '24 ноя, 17:14',
            dateBackward: '24 дек, 22:00',
            directionsShown: true,
            hasTransferWithStationChange: false,
            isCancelled: false,
            trains: [
                {
                    number: '339Г',
                    from: 'Москва',
                    to: 'Санкт-Петербург',
                    firmName: 'Ласточка',
                },
                {
                    number: '146У',
                    from: 'Екатеринбург',
                    to: 'Москва',
                    firmName: null,
                },
            ],
            link: `/my/order/${exampleTestingTrainOrder.orderId}`,
        },
        undefined,
        undefined,
        {
            title: 'Екатеринбург — Санкт-Петербург',
            dateForward: '3 мая, 23:59',
            dateBackward: null,
            directionsShown: false,
            hasTransferWithStationChange: true,
            isCancelled: false,
            trains: [
                {
                    number: '091И',
                    from: 'Екатеринбург',
                    to: 'Москва',
                    firmName: null,
                },
                {
                    number: '756А',
                    from: 'Москва',
                    to: 'Санкт-Петербург',
                    firmName: 'Сапсан',
                },
            ],
            link: '/my/order/8',
        },
        {
            title: 'Сочи — Казань',
            dateForward: '24 ноя, 17:14',
            dateBackward: null,
            directionsShown: false,
            hasTransferWithStationChange: true,
            isCancelled: true,
            trains: [
                {
                    number: '339Г',
                    from: 'Москва',
                    to: 'Санкт-Петербург',
                    firmName: 'Ласточка',
                },
                {
                    number: '146У',
                    from: 'Екатеринбург',
                    to: 'Москва',
                    firmName: null,
                },
            ],
            link: '/my/order/9',
        },
    ],
    hotelOrders: [
        {
            title: 'Друзья на Банковском',
            dates: '24 ноя — 24 дек',
            address: 'Санкт-Петербург, площадь Александра Невского, 2',
            isCancelled: false,
            link: `/my/order/${exampleTestingHotelOrder.orderId}`,
        },
        {
            title: 'Апартаменты Chalet With 5 Bedrooms in Cogollos de Guadix, With Wonderful Mountain View, Private Pool and Furnished Terrace - 160 km From the Beach 5',
            dates: '24 ноя — 24 дек',
            address:
                'Санкт-Петербург, площадь Александра Невского Таврического геральдического, 2',
            isCancelled: false,
            link: '/my/order/12',
        },
        {
            title: 'Amsterdam Sunny Top Floor 2',
            dates: '24 ноя — 24 дек',
            address: 'Санкт-Петербург, площадь Александра Невского, 2',
            link: '/my/order/13',
            isCancelled: true,
        },
        {
            title: 'Апартаменты Chalet 2',
            dates: '28 ноя — 29 дек',
            address: 'Санкт-Петербург, площадь Александра Невского, 2',
            link: '/my/order/14',
            isCancelled: true,
        },
    ],
};

export const tripsSearchOrder = {
    url: '/my/trips/search',
};

export const trips = {
    url: '/my/trips',
    name: prepareName(SUITE_NAME_PREFIX, 'Мои поездки'),
};

export const trip = {
    url(id: string): string {
        return `/my/trips/${id}`;
    },
    name: prepareName(SUITE_NAME_PREFIX, 'Моя поездка'),
};
