function nDaysAhead(n: number): string {
    const date = new Date();
    date.setDate(date.getDay() + n);

    return date.toISOString().split('T')[0];
}

const BASE_URL = 'https://travel-test.yandex.ru';
const TEN_DAYS_AHEAD = nDaysAhead(10);
const TWELVE_DAYS_AHEAD = nDaysAhead(12);

export enum EReleasePage {
    AVIA_MAIN = 'avia.main',
    AVIA_DATE_SEARCH = 'avia.dateSearch',
    AVIA_ROUTE = 'avia.route',
    AVIA_FLIGHT = 'avia.flight',

    TRAINS_MAIN = 'trains.main',
    TRAINS_DIRECTION_SEARCH = 'trains.directionSearch',
    TRAINS_DATE_SEARCH = 'trains.dateSearch',

    HOTELS_MAIN = 'hotels.main',
    HOTELS_DATE_SEARCH = 'hotels.dateSearch',
    HOTELS_HOTEL = 'hotels.hotel',
    HOTELS_GEO_REGION = 'hotels.geoRegion',

    BUSES_MAIN = 'buses.main',
    BUSES_DIRECTION_SEARCH = 'buses.directionSearch',
    BUSES_DATE_SEARCH = 'buses.dateSearch',
    BUSES_CITY = 'buses.city',
}

export const RELEASE_PAGES_URLS: Record<EReleasePage, string> = {
    [EReleasePage.AVIA_MAIN]: `${BASE_URL}/avia/`,
    [EReleasePage.AVIA_DATE_SEARCH]: `${BASE_URL}/avia/search/result/?adult_seats=1&children_seats=0&fromId=c213&infant_seats=0&klass=economy&oneway=1&return_date=&toId=c2&when=${TEN_DAYS_AHEAD}`,
    [EReleasePage.AVIA_ROUTE]: `${BASE_URL}/avia/routes/moscow--saint-petersburg/`,
    [EReleasePage.AVIA_FLIGHT]: `${BASE_URL}/avia/flights/SU-1404/`,
    [EReleasePage.TRAINS_MAIN]: `${BASE_URL}/trains/`,
    [EReleasePage.TRAINS_DIRECTION_SEARCH]: `${BASE_URL}/trains/moscow--saint-petersburg/`,
    [EReleasePage.TRAINS_DATE_SEARCH]: `${BASE_URL}/trains/moscow--saint-petersburg/?when=${TEN_DAYS_AHEAD}`,
    [EReleasePage.HOTELS_MAIN]: `${BASE_URL}/hotels/`,
    [EReleasePage.HOTELS_DATE_SEARCH]: `${BASE_URL}/hotels/search/?adults=2&bbox=37.39523700000001%2C55.601757~37.782114999999976%2C55.861348&checkinDate=${TEN_DAYS_AHEAD}&checkoutDate=${TWELVE_DAYS_AHEAD}&childrenAges=&geoId=213&navigationToken=0&selectedSortId=relevant-first`,
    [EReleasePage.HOTELS_HOTEL]: `${BASE_URL}/hotels/moscow/metamoskva/?adults=2&checkinDate=${TEN_DAYS_AHEAD}&checkoutDate=${TWELVE_DAYS_AHEAD}&childrenAges=`,
    [EReleasePage.HOTELS_GEO_REGION]: `${BASE_URL}/hotels/moscow/`,
    [EReleasePage.BUSES_MAIN]: `${BASE_URL}/buses/`,
    [EReleasePage.BUSES_DIRECTION_SEARCH]: `${BASE_URL}/buses/moscow--saint-petersburg/`,
    [EReleasePage.BUSES_DATE_SEARCH]: `${BASE_URL}/buses/moscow--saint-petersburg/?date=${TEN_DAYS_AHEAD}`,
    [EReleasePage.BUSES_CITY]: `${BASE_URL}/buses/moscow/`,
};

export default RELEASE_PAGES_URLS;
