const path = require('path');
const fse = require('fs-extra');
const express = require('express');
const webpack = require('webpack');
const webpackDevMiddleware = require('webpack-dev-middleware');
const webpackHotMiddleware = require('webpack-hot-middleware');

const webpackSettingsPath = path.resolve(__dirname, '..', 'webpack');
const clientWebpackConfig = require(`${webpackSettingsPath}/client.webpack.config`);
const {
    clientBuildPath,
} = require(`${webpackSettingsPath}/utilities/getPathParams`);

const {withHotReload} = require('../webpack/variables');
const CLIENT_PORT = 9001;

fse.removeSync(clientBuildPath);

const preventExtractPluginStats = webpackCompiler => {
    const shouldPickStatChild = child =>
        !child.name.includes('mini-css-extract-plugin');

    webpackCompiler.hooks.done.tap('mini-css-extract-plugin', stats => {
        const statsChildren = stats.compilation.children;

        if (Array.isArray(statsChildren)) {
            stats.compilation.children = statsChildren.filter(child =>
                shouldPickStatChild(child),
            );
        }
    });
};

const webpackClientCompiler = webpack(clientWebpackConfig);

const webpackDevMiddlewareInstance = webpackDevMiddleware(
    webpackClientCompiler,
    {
        serverSideRender: true,
        writeToDisk: () => true,
        stats: {
            env: true,
            colors: true,
            errors: true,
            chunks: false,
            assets: false,
            modules: false,
            errorDetails: false,
        },
    },
);

const app = express();

app.use(webpackDevMiddlewareInstance);

app.listen(CLIENT_PORT, () =>
    console.log(`Dev client is listening on ${CLIENT_PORT}`),
);

preventExtractPluginStats(webpackClientCompiler);

const webpackHotMiddlewareInstance =
    withHotReload && webpackHotMiddleware(webpackClientCompiler);

if (webpackHotMiddlewareInstance) {
    app.use(webpackHotMiddlewareInstance);
}
