const path = require('path');
const webpack = require('webpack');
const {isEmpty: _isEmpty} = require('lodash');
const webpackDevMiddleware = require('webpack-dev-middleware');

const webpackSettingsPath = path.resolve(__dirname, '..', 'webpack');
const serverWebpackConfig = require(`${webpackSettingsPath}/server.webpack.config`);

let buildDevMiddlewares = {};

module.exports = () => {
    const canStartWebpackBuild = _isEmpty(buildDevMiddlewares);

    if (canStartWebpackBuild) {
        const webpackMultiCompiler = webpack(serverWebpackConfig);

        const webpackDevMiddlewareInstance = webpackDevMiddleware(
            webpackMultiCompiler,
            {
                serverSideRender: true,
                writeToDisk: () => true,
                stats: {
                    env: true,
                    colors: true,
                    errors: true,
                    chunks: false,
                    assets: false,
                    modules: false,
                    errorDetails: false,
                },
            },
        );

        // каждый ребилд сервера убираем из рекваер кеша его аутпут,
        // после этого сервер заиспользует свежесбиилженные файлы
        webpackMultiCompiler.hooks.done.tap('DevServerCleanupPlugin', () => {
            Object.keys(require.cache).forEach(id => {
                if (
                    id.includes('loadable-stats.json') ||
                    id.includes('build/server/renderServer.js') ||
                    id.includes('build/server/renderAmpServer.js') ||
                    id.includes('build/server/apiController.js')
                ) {
                    delete require.cache[id];
                }
            });
        });

        buildDevMiddlewares = {
            webpackDevMiddlewareInstance,
        };
    }

    return buildDevMiddlewares;
};
