/* eslint-disable camelcase */

import {CurrencyType} from 'utilities/currency/CurrencyType';

export interface ISubscribeParams {
    qid: string;
    minPrice: {
        value: number;
        currency: CurrencyType;
    };
}

export interface ISubscriptionsParams {
    qid: string;
}

export interface ISubscriptionsAnswer {
    id: string;
    subscribed: boolean;
    date_range: number;
    filter: any;
    qkey: string;
}

export interface ISubscribeByEmailParams extends ISubscribeParams {
    email: string;
}

export interface ISubscribeByEmailAnswer {
    data: {
        id: string;
        pending: boolean;
        required_double_opt_in: boolean;
    };
    status: string;
}

export interface IUnsubscribeParams {
    id: string;
}

export interface IUnsubscribeByDirectionParams {
    qkey: string;
    id: string;
}

export interface IConfirmSubscriptionsParams {
    id: string;
    p: string;
    s: string;
}

export interface IConfirmSubscriptionAnswer {
    confirmed: boolean;
    id: string;
}
