import {
    IGeoLookupParams,
    IGeoLookupResponse,
} from 'server/api/AviaBackendApi/types/IGeoLookup';

import {
    IAviaBackendApiClient,
    IAviaBackendRequest,
} from 'server/utilities/AviaBackendApiClient/IAviaBackendApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaBackendApi {
    private aviaBackendApiClient: IAviaBackendApiClient;

    constructor({aviaBackendApiClient}: IDependencies) {
        this.aviaBackendApiClient = aviaBackendApiClient;
    }

    geoLookup(params: IGeoLookupParams): Promise<IGeoLookupResponse | null> {
        return this.aviaBackendApiClient.request<IGeoLookupResponse>(
            this.geoLookupOptions(params),
        );
    }

    private geoLookupOptions(params: IGeoLookupParams): IAviaBackendRequest {
        return {
            name: 'geoLookup',
            params,
            fields: [
                {
                    name: 'searchCity',
                    fields: ['geoId', 'title', 'country'],
                },
            ],
        };
    }
}
