// Интерфейсы перенесены не полностью
// Так как считается, что geoLookup работает медленно
// И к нему стоит обращаться только, если другие ручки не подходят

// Запроса
// curl "http://backend.production.avia.yandex.net/?national_version=ru&lang=ru&name=geoLookup" \
//     -X POST -d '[{"name":"geoLookup","params":{"geoId":"10725"},"fields":[{"name":"searchCity","fields":["id","key","title","geoId","code","iataCode","hasTaxi","phraseFrom","phraseTo","urlTitle","hasAirport","latitude","longitude","utcoffset","titleLocative"]}]}]' \
//     -H "Accept: application/json" \
//     -H "Content-Type: application/json"

// Ответ
// {"status": "success",
//     "data":[{"searchCity":{"code":"MOW","title":"Москва","urlTitle":"Moskva","iataCode":"MOW","titleLocative":"Москве","longitude":37.619899,"id":213,"utcoffset":10800,"phraseFrom":"Москвы","key":"c213","hasAirport":true,"latitude":55.753676,"hasTaxi":true,"phraseTo":"Москву","geoId":213}}]}

import {TGeoId} from 'types/TGeoId';

export interface IGeoLookupParams {
    geoId: number | undefined;
}

interface IGeoLookupCountry {
    id: number;
    title: string;
}

interface IGeoLookupPoint {
    geoId: TGeoId;
    title: string;
    country: IGeoLookupCountry;
}

export interface IGeoLookupResponse {
    searchCity: IGeoLookupPoint;
}
