/**
 * http://api.travel-balancer-test.yandex.net/swagger-ui.html#/test-context-controller/getAviaTokenUsingGET
 */

export enum ECheckAvailabilityOnRedirOutcome {
    UNKNOWN = 'CAOR_UNKNOWN',
    SUCCESS = 'CAOR_SUCCESS',
    PRICE_CHANGED = 'CAOR_PRICE_CHANGED',
    NOT_AVAILABLE = 'CAOR_NOT_AVAILABLE',
}

export enum ECheckAvailabilityBeforeBookingOutcome {
    UNKNOWN = 'CAO_UNKNOWN',
    SUCCESS = 'CAO_SUCCESS',
    PRICE_CHANGED = 'CAO_PRICE_CHANGED',
}

export enum ETokenizationOutcome {
    UNKNOWN = 'TO_UNKNOWN',
    SUCCESS = 'TO_SUCCESS',
    FAILURE = 'TO_FAILURE',
}

export enum EConfirmationOutcome {
    UNKNOWN = 'CO_UNKNOWN',
    SUCCESS = 'CO_SUCCESS',
    PAYMENT_FAILED = 'CO_PAYMENT_FAILED',
    VARIANT_NOT_AVIALABLE = 'CO_VARIANT_NOT_AVIALABLE',
    PRICE_CHANGED = 'CO_PRICE_CHANGED',
}

export enum EMqEventOutcome {
    UNKNOWN = 'MEO_UNKNOWN',
    NO_EVENT = 'MEO_NO_EVENT',
    SUCCESS = 'MEO_SUCCESS',
    NOT_PAID = 'MEO_NOT_PAID',
}

export interface IAviaTestContextTokenApiParams {
    /**
     * Результат проверки доступности варианта при редиректе на BoY
     */
    checkAvailabilityOnRedirOutcome: ECheckAvailabilityOnRedirOutcome;
    /**
     * Результат проверки доступности варианта перед созданием заказа
     */
    checkAvailabilityBeforeBookingOutcome: ECheckAvailabilityBeforeBookingOutcome;
    /**
     * Результат токенизации карты
     */
    tokenizationOutcome: ETokenizationOutcome;
    /**
     * Результат подтверждения бронирования заказа
     */
    confirmationOutcome: EConfirmationOutcome;
    /**
     * Тип MQ события, присылаемого аэрофлотом о статусе заказа
     */
    mqEventOutcome: EMqEventOutcome;
    /**
     * Включить моки авиа выдачи
     */
    mockAviaVariants?: boolean;
    /**
     * Mock-объекты вариантов на выдаче в JSON
     * @link https://st.yandex-team.ru/RASPTICKETS-21483#61fd18b698682257e2b4f327
     */
    aviaVariants?: string;
}
