/* eslint-disable camelcase */
import {IReferenceDTO} from 'server/api/AviaBookingApi/types/IReferenceDTO';
import {ISegmentFare} from 'server/api/AviaBookingApi/types/ISegmentFare';
import {EAviaLoyaltyCardType} from 'types/avia/book/EAviaLoyaltyCardType';

import IPrice from 'utilities/currency/PriceInterface';

import {IBookingDateTime} from './IBookingDateTime';

export interface IBookingFlight {
    to: number;
    key: string;
    from: number;
    number: string;
    arrival: IBookingDateTime;
    company: number;
    departure: IBookingDateTime;
    aviaCompany: number;
    companyTariff: number;
}

export interface IBookingFlights {
    [key: string]: IBookingFlight;
}

export interface IBookingVariant {
    tag: string;
    route: string[][];
    expire: number;
    tariff: IPrice;
    baggage: string[][];
    charter: null | boolean;
    created: number;
}

// tslint:disable-next-line:no-empty-interface
export interface IBookingYauser {}

export interface IBookingDjangoUser {
    is_staff: boolean;
}

export interface IBookingUserInfo {
    userip: string;
    yauser: IBookingYauser;
    yandexuid: string;
    django_user: IBookingDjangoUser;
}

export interface IBookingOrderData {
    qid: string;
    url: string;
    lang: string;
    qkey: string;
    tariff: IPrice;
    partner: string;
    national_version: string;
}

/** TODO: Уточнить у tlg-13 не повторяет ли это общий IPrice */
export interface IBookingShownTariff {
    value: string;
    currency: string;
}

export interface IBookingPriceInfo {
    first_check_price: IPrice;
    preliminary_price: IPrice;
}

export interface IFlightStopDTO {
    airportId: number;
    terminal: string;
}

export interface IFlightDTO {
    id: string;
    to: number;
    from: number;
    stops: IFlightStopDTO[] | null;
    number: string | null;
    arrival: string;
    departure: string;
    marketingAviaCompany: number;
    operatingAviaCompany: number;
    fareTerms: ISegmentFare;
}

export type TFareFamilyParameter =
    | 'description'
    | 'meal'
    | 'baggage'
    | 'carry_on'
    | 'refundable'
    | 'exchangeable'
    | 'seats_registration'
    | 'miles'
    | 'vip_service';

export type TParameterAvailability =
    | 'free'
    | 'not_available'
    | 'charge'
    | 'display';

export interface IFareFamilyParameterDTO {
    type: TFareFamilyParameter;
    shortDescription: string;
    fullDescription: string;
    fullDescriptionOrig: string;
    availability: TParameterAvailability;
}

export interface IFareFamilyInfoDTO {
    description: string;
    options: IFareFamilyParameterDTO[];
}

export interface ISegmentDTO {
    flights: IFlightDTO[];
    fareFamilyInfo?: IFareFamilyInfoDTO;
}

export interface IBookingFareInfo {
    flightId: string;
    fareBasis: string;
    fareFamilyCode: string;
}

export interface ICategoryPriceDTO {
    fare: IPrice;
    taxes: IPrice;
    total: IPrice;
    fareInfo: IBookingFareInfo[];
    quantity: number;
    passengerCategory: string;
}

export interface IVariantPriceInfoDTO {
    id: string;
    total: IPrice;
    agencyMarkup: IPrice | null;
    categoryPrices: ICategoryPriceDTO[];
}

export interface IPromo2020Campaign {
    eligible?: boolean;
}

export interface IYandexPlusPromoCampaign {
    enabled: boolean;
    totalPlusPoints: number;
}

export type TBookingPromoCampaigns = {
    promo2020?: IPromo2020Campaign;
    plusPromo2021?: IYandexPlusPromoCampaign;
};

export interface IBookingAllVariant {
    id: string;
    legs: ISegmentDTO[];
    promoCampaigns?: TBookingPromoCampaigns;
    variantPriceInfo: IVariantPriceInfoDTO;
    allowedLoyaltyPrograms: EAviaLoyaltyCardType[];
}

export interface IBookingVariantInfo {
    variant: IBookingAllVariant;
    reference: IReferenceDTO;
}

export interface IBookingRedirectOrderData {
    url: string;
}

export interface IBookingRedirectData {
    order_data: IBookingRedirectOrderData;
    query_source: string;
}

export interface IBookingDirectionData {
    number: string;
    departure_datetime: number;
}

export interface IBookingPassengers {
    adults: number;
    infants: number;
    children: number;
}

export interface IBookingAdditionalData {
    qid: string;
    lang: string;
    klass: string;
    marker: string;
    forward: IBookingDirectionData[];
    partner: string;
    service: string;
    backward: IBookingDirectionData[] | null;
    point_to: any[];
    user_info: IBookingUserInfo;
    passengers: IBookingPassengers;
    point_from: any[];
    utm_medium: string;
    utm_source: string;
    tariff_sign: string;
    utm_content: string;
    date_forward: number;
    shown_tariff: IBookingShownTariff;
    utm_campaign: string;
    with_baggage: boolean;
    date_backward?: any;
    book_on_yandex: boolean;
    national_version: string;
}

export interface IBookingVariantsResponse {
    flights: IBookingFlights;
    variant: IBookingVariant;
    user_info: IBookingUserInfo;
    created_at: number;
    order_data: IBookingOrderData;
    price_info: IBookingPriceInfo;
    utm_source: string;
    all_variants: IBookingAllVariant[];
    query_source: string;
    variant_info: IBookingVariantInfo;
    redirect_data: IBookingRedirectData;
    additional_data: IBookingAdditionalData;
}
