import {EAviaLoyaltyCardType} from 'types/avia/book/EAviaLoyaltyCardType';

import {AviaDocumentType} from '../enums/DocumentType';

export interface IAviaCreateOrderDocumentDTO {
    firstName: string;
    lastName: string;
    middleName: string | undefined;
    /** Дата в формате YYYY-MM-DD */
    dateOfBirth: string;
    sex: 'male' | 'female' | undefined;
    citizenship: string;
    documentType: AviaDocumentType;
    documentNumber: string;
    /** Дата в формате YYYY-MM-DD */
    documentValidTill: string;
    loyaltyProgramInternalCode: EAviaLoyaltyCardType | undefined;
    loyaltyProgramAccountNumber: string | undefined;
}

export interface IAviaCreateOrderApiRequest {
    documents: IAviaCreateOrderDocumentDTO[];
    email: string;
    phone: string;
    variantToken: string;
    paymentTestContextToken?: string;
    marker?: string;
    userIp?: string;
    userAgent?: string;
}
