import {IBookingDateTime} from '../../AviaBookingApi/types/IBookingDateTime';
import {OrderErrorType} from '../../AviaBookingApi/types/OrderErrorType';
import {OrderStateType} from '../../AviaBookingApi/types/OrderStateType';
import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';

import IPrice from 'utilities/currency/PriceInterface';

import {IReferenceDTO} from './IReferenceDTO';
import {ITravellerInfoDTO} from './ITravellerInfoDTO';
import {IAirReservationDTO} from './IAirReservationDTO';

export interface IOrderDTO {
    id: string;
    prettyId: string;
    partner: string;
    orderRefNum: string;
    email: string;
    phone: string;
    airReservation: IAirReservationDTO;
    travellers: ITravellerInfoDTO[];
    preliminaryPrice: IPrice;
    price: IPrice;
    agencyMarkup: IPrice;
    paymentCanBeInitialized: boolean;
    state: OrderStateType;
    edisplayOrderState: EDisplayOrderState;
    timeLimitAt: IBookingDateTime;
    fareRulesUrl: string;
    errorCode: OrderErrorType;
    reference: IReferenceDTO;
    tripId?: string | null;
}
