import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {IAviaTestContextTokenApiParams} from 'server/api/AviaBookingApi/types/IAviaTestContextTokenApiParams';
import {IAviaTestContextTokenApiResponse} from 'server/api/AviaBookingApi/types/IAviaTestContextTokenApiResponse';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaBookingTestContextApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        requestId,
        sendClickHouseStats,
        getApiHost,
        getSrcParams,
        getServiceTicket,
        rootSpan,
    }: IDependencies) {
        super({
            baseURL: getApiHost(EApiEntry.TRAVEL) + '/test_context/v1',
            requestId,
            logger,
            httpClient,
            sendClickHouseStats,
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.TRAVEL);
        this.serviceTicket = getServiceTicket('travelAPI');
    }

    getTestContextToken(
        params: IAviaTestContextTokenApiParams,
    ): Promise<IAviaTestContextTokenApiResponse> {
        return this.get<IAviaTestContextTokenApiResponse>('avia_token', {
            params,
            convertResponseKeysToCamelCase: true,
        });
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.timeout = 25000;
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
        };
    }
}
