import {CommonHeaders} from 'server/constants/headers';

import {EApiEntry} from 'types/EApiEntry';
import {
    IGetCountryRestrictionsResponse,
    IGetExtendedCountryRestrictionsResponse,
} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';
import {TGetCountryRestrictionsRequest} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiRequest';

import {RestApiClient} from 'server/utilities/RestApiClient';
import {IRequestConfig} from 'server/utilities/HttpClient/IHttpClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaCountryRestrictionsApi extends RestApiClient {
    private readonly serviceTicket: string;

    constructor({
        logger,
        httpClient,
        requestId,
        getApiHost,
        getSrcParams,
        getServiceTicket,
    }: IDependencies) {
        super({
            httpClient,
            baseURL: getApiHost(EApiEntry.TRAVEL),
            logger,
            requestId,
        });

        this.srcParams = getSrcParams(EApiEntry.TRAVEL);
        this.serviceTicket = getServiceTicket('travelAPI');
    }

    async getCountryRestrictions(
        params: TGetCountryRestrictionsRequest,
    ): Promise<IGetCountryRestrictionsResponse> {
        return this.get<IGetCountryRestrictionsResponse>(
            '/avia_country_restrictions/v1/data',
            {
                params,
            },
        );
    }

    async getExtendedCountryRestrictions(
        params: TGetCountryRestrictionsRequest,
    ): Promise<IGetExtendedCountryRestrictionsResponse> {
        return this.get<IGetExtendedCountryRestrictionsResponse>(
            '/avia_country_restrictions/v1/extended',
            {
                params,
            },
        );
    }

    protected async interceptRequest(request: IRequestConfig): Promise<void> {
        request.headers = {
            ...request.headers,
            [CommonHeaders.X_YA_SERVICE_TICKET]: this.serviceTicket,
            [CommonHeaders.X_YA_USE_CAMELCASE]: 'true',
        };
    }
}
