export interface ITextElementData {
    text: string;
}

export interface IUrlElementData {
    text: string;
    url: string;
}

export enum ERichStringBlockType {
    TEXT = 'text',
    URL = 'url',
}

export type TRichStringBlockVariants =
    | {
          blockType: ERichStringBlockType.URL;
          data: IUrlElementData;
      }
    | {
          blockType: ERichStringBlockType.TEXT;
          data: ITextElementData;
      };

export interface IRichString {
    data: TRichStringBlockVariants[];
}
