import {TGeoId} from 'types/TGeoId';
import {TPointKey} from 'types/PointKey';
import {TInstantDateTimeType} from 'types/common/date/IDate';
import {DateType} from 'types/hotels/common/IDate';

import {IRichString} from './IRichString';

export enum EPointType {
    UNKNOWN = 0,
    STATION = 1,
    SETTLEMENT = 2,
    REGION = 3,
    COUNTRY = 4,
}

export interface IPointInfo {
    geo_id: TGeoId | null;
    point_key: TPointKey;
    // TODO: нужно поправить на бэке на camelCase
    title: {nominative_case?: string};
    type: EPointType;
}

export interface ICommonMetric {
    text: IRichString;
    additions: IRichString[];
    exclusions: IRichString[];
    updatedTime: TInstantDateTimeType;
    lastModificationTime: TInstantDateTimeType;
    // TODO: нужно поправить на бэке на camelCase
    point_info: IPointInfo;
}

export interface ICustomTypeMetric<CustomType> extends ICommonMetric {
    value: CustomType;
}

export interface IBooleanMetric extends ICommonMetric {
    value: boolean;
}

export interface INumberOrBooleanMetric extends ICommonMetric {
    value: number | boolean;
}

export interface IStringListMetric extends ICommonMetric {
    value: string[];
}

export interface IDateMetric extends ICommonMetric {
    value: DateType;
}

export enum EFlightsAvailabilityV2 {
    DIRECT_FLIGHTS = 'directFlights',
    TRANSFER_FLIGHTS = 'transferFlights',
    NO_FLIGHTS = 'noFlights',
}

export enum EEntranceForRussians {
    FREE_ENTRANCE = 'freeEntrance',
    HAS_RESTRICTIONS = 'hasRestrictions',
    NO_ENTRANCE = 'noEntrance',
}

export interface IBankCardPayments {
    russian_visa_mastercard?: boolean;
    mir?: boolean;
    union_pay?: boolean;
}

export type TRestrictionMetric =
    | ICustomTypeMetric<EFlightsAvailabilityV2>
    | ICustomTypeMetric<EEntranceForRussians>
    | ICustomTypeMetric<IBankCardPayments>
    | IDateMetric
    | IBooleanMetric
    | INumberOrBooleanMetric
    | IStringListMetric;

export interface IPointRestrictions {
    flightsAvailability?: IBooleanMetric;
    tourismAvailability?: IBooleanMetric;
    tourismAvailableFrom?: IDateMetric;
    quarantineRequired?: INumberOrBooleanMetric;
    visaRequired?: IBooleanMetric;
    covidInsuranceRequired?: IBooleanMetric;
    mobileAppRequired?: IBooleanMetric;
    pcrExpirationPeriodInHoursOrRequired?: INumberOrBooleanMetric;
    approvedVaccines?: IStringListMetric;
    isSputnikApproved?: IBooleanMetric;
    formsToFill?: IStringListMetric;
    flightsAvailabilityV2?: ICustomTypeMetric<EFlightsAvailabilityV2>;
    entranceForRussians?: ICustomTypeMetric<EEntranceForRussians>;
    bankCardPayments?: ICustomTypeMetric<IBankCardPayments>;
    [name: string]: TRestrictionMetric | undefined;
}

export interface IDestinationInformation {
    metrics: IPointRestrictions;
}

export interface IGetCountryRestrictionsResponse {
    destination: IDestinationInformation;
}

export enum ECountryRestrictionsColor {
    GRAY = 'gray',
    GREEN = 'green',
    RED = 'red',
}

export enum EExtendedCountryRestrictionsMetricIcons {
    PLANE = 'Plane',
    SHILD = 'Shild',
    CARD = 'Card',
    QUESTIONNAIRE = 'Questionnaire',
    QUARANTINE = 'Quarantine',
    DISCOVERY = 'Discovery',
    WARNING_FILLED = 'WarningFilled',
    COVID_SHILD = 'CovidShild',
    GLOBE = 'Globe',
}

export interface IGetExtendedCountryRestrictionsMetric {
    title: IRichString;
    icon24: EExtendedCountryRestrictionsMetricIcons;
    metricName: string;
    /**
     * if null/undefined, there should be only icon and title
     */
    metricValue?: ICommonMetric;
}

export interface IGetExtendedCountryRestrictionsResponse {
    color: ECountryRestrictionsColor;
    /**
     * upper part of minimized banner
     */
    titleText: string;
    /**
     * desktop lower part of minimized banner
     */
    desktopMinimized: string[];
    /**
     * mobile lower part of minimized banner
     */
    mobileMinimized: string[];
    expandedBannerMetrics: IGetExtendedCountryRestrictionsMetric[];

    /** опциональный id страны */
    countryId?: number;
}
