import {
    IFlightDetailedParams,
    IFlightInfo,
} from 'server/api/AviaFlightStorageApi/types/IFlight';
import {EApiEntry} from 'types/EApiEntry';

import {RestApiClient} from 'server/utilities/RestApiClient';

import {IDependencies} from 'server/getContainerConfig';

export class AviaFlightStorageApi extends RestApiClient {
    constructor({
        httpClient,
        getApiHost,
        getSrcParams,
        logger,
        requestId,
        sendClickHouseStats,
        rootSpan,
    }: IDependencies) {
        super({
            logger,
            requestId,
            httpClient,
            sendClickHouseStats,
            baseURL: getApiHost(EApiEntry.FLIGHT_STORAGE),
            rootSpan,
        });

        this.srcParams = getSrcParams(EApiEntry.FLIGHT_STORAGE);
    }

    async flightDetailed({
        iata,
        number,
        flightDay,
        fromAirportCode,
    }: IFlightDetailedParams): Promise<IFlightInfo> {
        return await this.get<IFlightInfo>(`${iata}/${number}/${flightDay}/`, {
            params: {
                fields: ['flight_status', 'flight_extras'].join(','),
                ...(fromAirportCode && {
                    'from-airport-code': fromAirportCode,
                }),
            },
        });
    }
}
