/* eslint-disable camelcase */

export interface IFlightDetailedParams {
    iata: string;
    number: string;
    flightDay: string;
    fromAirportCode?: string;
}

export interface IFlightInfo {
    flight: IFlight;
    flight_status: IFlightStatus;
    airport_from: IAirport;
    airport_to: IAirport;
    airline: IAirline;
}

export interface IBaseFLight {
    departure_utc: string; // "2019-03-27 03:00:00",
    departure_day: string; // "2019-03-27",
    departure_time: string; // "13:00:00",
    departure_timezone: string; // "Asia/Vladivostok",
    airport_from_code: string; // "VVO",
    airport_from_id: number; // 9626399,

    arrival_utc: string; // "2019-03-27 17:45:00",
    arrival_day: string; // "2019-03-27"
    arrival_time: string; // "20:45:00",
    arrival_timezone: string; // "Europe/Moscow",
    airport_to_code: string; // "LED",
    airport_to_id: number; // 9600366,

    created_at: string; // "2019-03-27 10:38:04",
    updated_at: string; // "2019-03-27 10:38:04",

    airline_id: number; // 30,
    airline_iata: string; // "U6",
    number: string; // "U6 366",
}

export interface IFlight extends IBaseFLight {
    segments: IFlightInfo[];
}

export interface INearFlight extends IBaseFLight {
    segments: INearFlight[];
}

export interface IFlightStatus {
    departure: string; // "2019-04-01 13:17:00",
    departure_status: string; // "departed",
    departure_gate: string; // "",
    departure_terminal: string; // "ВВЛ",
    departure_source: string; // "aurora",

    arrival: string; // "2019-04-01 18:20:00",
    arrival_status: string; // "unknown",
    arrival_gate: string; // "",
    arrival_terminal: string; // "",
    arrival_source: string; // "airport"

    status: string; // "on_time",

    created_at: string; // "2019-03-29 00:06:52",
    updated_at: string; // "2019-04-01 15:45:20",

    baggage_carousels?: string;
    check_in_desks?: string;
}

export interface IAirport {
    timeZoneUtcOffset: number; // 600,
    code: string; // "VVO",
    urlTitle: string; // "Knevichi",
    popularTitle: string; // "Кневичи",
    title: string; // "Кневичи",
    iataCode: string; // "VVO",
    longitude: number; // 132.148056,
    phraseFrom: string; // "Кневичи",
    key: string; // "s9626399",
    stationType: {
        prefix: string; // "а/п",
        title: string; // "аэропорт"
    };
    latitude: number; // 43.398889,
    timeZone: string; // "Asia/Vladivostok",
    phraseIn: string; // "Кневичи",
    settlement: ISettlement;
    phraseTo: string; // "Кневичи",
    id: number; // 9626399
}

export interface ISettlement {
    code: string; // MOV
    title: string; // "Владивосток",
    country: {
        geoId: number; // 225,
        title: string; // "Россия"
    };
    longitude: number; // 131.882421,
    geoId: number; // 75,
    latitude: number; // 43.116391,
    id: number; // 75
}

export interface IAirline {
    alliance: string | null;
    title: string; // "Уральские авиалинии",
    url: string; // "http://www.uralairlines.ru/",
    iata: string; // "U6",
    logoSvg: string; // "https://avatars.mds.yandex.net/get-avia/200364/2a0000015a80534291a2010a3106b2bddd70/svg",
    slug: string; // "u6_ural-airlines",
    color: string; // "#e30421",
    id: number; // 30
}
